Attribute VB_Name = "mdlSLIK"
'********************************************************************************
'
'                       C O P Y R I G H T  (c) 2002
'               N O R T H E R N    D Y N A M I C   I N C.
'                           All Rights Reserved.
'   ........................................................................
'   This sample code is provided by Northern Dynamic solely to assist in
'   understanding the use of the SLIK-DA ActiveX Control. This code is
'   provided as-is and without warranty or support of any sort.
'
'********************************************************************************
'
'   Project:        SLIK-DA ActiveX Control
'
'   Description:    This sample server application is based on Northern Dynamic's
'                   Simple Language Independent Toolkit for creating OPC
'                   Data Access servers (SLIK-DA). This implementation illustrates
'                   the use of various features of the SLIK-DA ActiveX Control.
'
'   Revision:
'       02-03-27    gmg     Initial release.
'
'********************************************************************************
Option Explicit

' Defaults defined by SLIK
Public Const c_nDefaultQuality As Integer = -1
Public Const c_nDefaultTimestamp As Long = 0

' Range of valid values for server statistics sample periods (in milliseconds)
Public Const c_nMinStatSamplePeriod As Long = 100
Public Const c_nMaxStatSamplePeriod As Long = 60000

' Range of valid values for minimum group update period (in milliseconds)
Public Const c_nMinGroupMinUpdatePeriod As Long = 10
Public Const c_nMaxGroupMinUpdatePeriod As Long = 60000

' SLIK Server Statistics
Public Const c_nStatSamplePeriod As Integer = 1
Public Const c_nStatClients As Integer = 2
Public Const c_nStatGroups As Integer = 3
Public Const c_nStatItems As Integer = 4
Public Const c_nStatReads As Integer = 5
Public Const c_nStatWrites As Integer = 6
Public Const c_nStatChanges As Integer = 7
Public Const c_nStatLogons As Integer = 8

Public Const c_sStatSamplePeriod As String = "SAMPLE_PERIOD"
Public Const c_sStatClients As String = "NUM_CLIENTS"
Public Const c_sStatGroups As String = "NUM_GROUPS"
Public Const c_sStatItems As String = "NUM_ITEMS"
Public Const c_sStatReads As String = "NUM_READS_PER_PD"
Public Const c_sStatWrites As String = "NUM_WRITES_PER_PD"
Public Const c_sStatChanges As String = "NUM_CHG_PER_PD"

'********************************************************************************
' Description:      Create the item namespace for this server. The items will be
'                   organized by access rights and data type. The item tags will
'                   make use of the SLIK server Namespace Delimiter property to
'                   create a hierarchial namespace.
'
' Parameters:
'   In:             SLIKServer - the instance of the SLIK server
'   Out:            None
'
' Return Value:     True - namespace created successfully
'                   False - error occurred
'********************************************************************************
Public Function InitNamespace(ByRef OpcServer As SLIKServer) As Boolean

    Const nTagsPerLeafFolder As Integer = 10
    
    Dim nAccess As Long
    Dim nIndex As Integer
    Dim Tag As ISLIKTag
    Dim Tags As ISLIKTags
    
    On Error GoTo errHandler

    Set Tags = OpcServer.SLIKTags
    
    '
    ' Create a set of tags that will change in value over time.
    '
    nAccess = sdaReadAccess
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.BOOL.tag" & Format(nIndex, "00"), nAccess, True, sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.UI1.tag" & Format(nIndex, "00"), nAccess, CByte(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.I2.tag" & Format(nIndex, "00"), nAccess, CInt(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.I4.tag" & Format(nIndex, "00"), nAccess, CLng(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.R4.tag" & Format(nIndex, "00"), nAccess, CSng(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.R8.tag" & Format(nIndex, "00"), nAccess, CDbl(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.BSTR.tag" & Format(nIndex, "00"), nAccess, CStr(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.DATE.tag" & Format(nIndex, "00"), nAccess, CDate(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("src.CY.tag" & Format(nIndex, "00"), nAccess, CCur(nIndex), sdaGood)
    Next nIndex
    
    '
    ' Create a set of tags that any OPC client may change.
    '
    nAccess = sdaReadAccess + sdaWriteAccess
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.BOOL.tag" & Format(nIndex, "00"), nAccess, True, sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.UI1.tag" & Format(nIndex, "00"), nAccess, CByte(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.I2.tag" & Format(nIndex, "00"), nAccess, CInt(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.I4.tag" & Format(nIndex, "00"), nAccess, CLng(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.R4.tag" & Format(nIndex, "00"), nAccess, CSng(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.R8.tag" & Format(nIndex, "00"), nAccess, CDbl(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.BSTR.tag" & Format(nIndex, "00"), nAccess, CStr(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.DATE.tag" & Format(nIndex, "00"), nAccess, CDate(nIndex), sdaGood)
    Next nIndex
    
    For nIndex = 1 To nTagsPerLeafFolder
        Set Tag = Tags.Add("trg.CY.tag" & Format(nIndex, "00"), nAccess, CCur(nIndex), sdaGood)
    Next nIndex
    
    InitNamespace = True

    Exit Function

errHandler:
    Call frmMain.ReportEvent(Err.Description, "Namespace initialization error")
    InitNamespace = False
    Exit Function

End Function

'********************************************************************************
' Description:      Convert the server status value to a string.
'
' Parameters:
'   In:             nStatus - Server status
'   Out:            None
'
' Return Value:     Text equivalent (or empty string if no match found)
'********************************************************************************
Public Function ServerStatusToStr(nStatus As NDISLIKDACtl.ServerStatusEnum) As String

    Select Case nStatus
    Case sdaStatusFailed
        ServerStatusToStr = "Failed"
    Case sdaStatusNoConfig
        ServerStatusToStr = "No Configuration"
    Case sdaStatusRunning
        ServerStatusToStr = "Running"
    Case sdaStatusSuspended
        ServerStatusToStr = "Suspended"
    Case sdaStatusTest
        ServerStatusToStr = "Test"
    Case Else
        ServerStatusToStr = "UNKNOWN!"
    End Select

End Function
